// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Docktabset.pas' rev: 10.00

#ifndef DocktabsetHPP
#define DocktabsetHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Tabs.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <Extctrls.hpp>	// Pascal unit
#include <Contnrs.hpp>	// Pascal unit
#include <Captioneddocktree.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Docktabset
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TTabDockPanel;
class DELPHICLASS TDockClientInfo;
class DELPHICLASS TDockTabSet;
class PASCALIMPLEMENTATION TDockTabSet : public Tabs::TTabSet 
{
	typedef Tabs::TTabSet inherited;
	
private:
	bool FAutoSelect;
	Contnrs::TObjectList* FDockClients;
	TDockClientInfo* FCurrentClient;
	Controls::TWinControl* FDestDockSite;
	Controls::TImageList* FInternalImages;
	Classes::TNotifyEvent FOnTabAdded;
	Classes::TNotifyEvent FOnTabRemoved;
	bool FShouldFocus;
	Extctrls::TTimer* FAutoPopTimer;
	int FAutoPopIndex;
	void __fastcall AutoPopTimerExec(System::TObject* Sender);
	Types::TRect __fastcall CalcDockSize(const Controls::TControl* Client);
	HIDESBASE MESSAGE void __fastcall CMDockClient(Controls::TCMDockClient &Message);
	MESSAGE void __fastcall CMDockNotification(Controls::TCMDockNotification &Message);
	HIDESBASE MESSAGE void __fastcall CMUnDockClient(Controls::TCMUnDockClient &Message);
	void __fastcall InvalidateDockSite(const Controls::TControl* Client, const bool FocusLost);
	void __fastcall SetDestDockSite(const Controls::TWinControl* Value);
	
protected:
	DYNAMIC void __fastcall DoAddDockClient(Controls::TControl* Client, const Types::TRect &ARect);
	DYNAMIC void __fastcall DockOver(Controls::TDragDockObject* Source, int X, int Y, Controls::TDragState State, bool &Accept);
	virtual bool __fastcall DockReplaceDockClient(Controls::TControl* Client, Controls::TWinControl* NewDockSite, Controls::TControl* DropControl, Controls::TAlign ControlSide, Controls::TControl* ReplacementClient);
	DYNAMIC void __fastcall DoRemoveDockClient(Controls::TControl* Client);
	TDockClientInfo* __fastcall FindDockClientInfo(const Controls::TControl* Client);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall SetTabIndex(int Value);
	virtual void __fastcall ShowDockClientInfo(const TDockClientInfo* DockClientInfo);
	virtual int __fastcall GetImageIndex(int TabIndex);
	virtual AnsiString __fastcall GetTabName(const Controls::TControl* Client);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	virtual bool __fastcall ShouldAutoHide(const Controls::TWinControl* Client);
	
public:
	__fastcall virtual TDockTabSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TDockTabSet(void);
	void __fastcall ShowDockClient(const Controls::TControl* Client);
	int __fastcall IndexOfDockClient(const Controls::TControl* Client);
	void __fastcall HideCurrentDockClient(const int AnimateSpeed = 0xc8);
	
protected:
	__property Images ;
	__property OnGetImageIndex ;
	
__published:
	__property bool AutoSelect = {read=FAutoSelect, write=FAutoSelect, default=0};
	__property DockSite  = {default=1};
	__property Controls::TWinControl* DestinationDockSite = {read=FDestDockSite, write=SetDestDockSite};
	__property OnDockDrop ;
	__property OnDockOver ;
	__property OnGetSiteInfo ;
	__property OnStartDock ;
	__property OnUnDock ;
	__property Classes::TNotifyEvent OnTabAdded = {read=FOnTabAdded, write=FOnTabAdded};
	__property Classes::TNotifyEvent OnTabRemoved = {read=FOnTabRemoved, write=FOnTabRemoved};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TDockTabSet(HWND ParentWindow) : Tabs::TTabSet(ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TDockClientInfo : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TDockTabSet* FDockTabSet;
	Controls::TWinControl* FDockClient;
	int FTabIndex;
	int FListIndex;
	TTabDockPanel* FParentPanel;
	int FImageIndex;
	void __fastcall SetTabIndex(const int Value);
	void __fastcall AddIconToImageList(void);
	
protected:
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	
public:
	__fastcall TDockClientInfo(const TDockTabSet* ADockTabSet, const Controls::TWinControl* ADockClient);
	__fastcall virtual ~TDockClientInfo(void);
	void __fastcall CreateTab(bool AlwaysCreate = false);
	__property Controls::TWinControl* DockClient = {read=FDockClient};
	__property TDockTabSet* DockTabSet = {read=FDockTabSet};
	__property int ImageIndex = {read=FImageIndex, write=FImageIndex, nodefault};
	__property int ListIndex = {read=FListIndex, nodefault};
	__property TTabDockPanel* ParentPanel = {read=FParentPanel};
	__property int TabIndex = {read=FTabIndex, write=SetTabIndex, nodefault};
};


class PASCALIMPLEMENTATION TTabDockPanel : public Extctrls::TPanel 
{
	typedef Extctrls::TPanel inherited;
	
private:
	Extctrls::TTimer* FAutoHideTimer;
	int FSplitterWidth;
	TDockClientInfo* FDockClientInfo;
	Extctrls::TPaintBox* FDockCaption;
	Extctrls::TPanel* FDockCaptionPanel;
	#pragma pack(push,1)
	Types::TPoint FDownPos;
	#pragma pack(pop)
	bool FFirstErase;
	int FGrabberSize;
	bool FInAnimation;
	Extctrls::TPanel* FSplitterPanel;
	#pragma pack(push,1)
	Types::TRect FStartingBounds;
	#pragma pack(pop)
	Captioneddocktree::TDockCaptionDrawer* FDockCaptionDrawer;
	unsigned FMouseDownTime;
	int FAnimateSpeed;
	Graphics::TBitmap* FBitmapPrintChache;
	bool FIsNotXP;
	Types::TRect __fastcall GetCaptionRect();
	void __fastcall AutoHideTimerExec(System::TObject* Sender);
	void __fastcall PaintDockCaption(System::TObject* Sender);
	void __fastcall SplitterMouseDown(System::TObject* Sender, Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	void __fastcall SplitterMouseMove(System::TObject* Sender, Classes::TShiftState Shift, int X, int Y);
	void __fastcall DockCaptionMouseUp(System::TObject* Sender, Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	void __fastcall DockCaptionMouseDown(System::TObject* Sender, Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	void __fastcall DockCaptionMouseMove(System::TObject* Sender, Classes::TShiftState Shift, int X, int Y);
	
protected:
	bool __fastcall ShouldAutoHide(void);
	void __fastcall BeginAnimation(void);
	void __fastcall EndAnimation(void);
	HIDESBASE MESSAGE void __fastcall CMShowingChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	HIDESBASE MESSAGE void __fastcall WMNCPaint(Messages::TWMNCPaint &Message);
	MESSAGE void __fastcall WMPrint(Messages::TWMPrint &Message);
	HIDESBASE MESSAGE void __fastcall WMPrintClient(Messages::TWMPrint &Message);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Message);
	__property int SplitterWidth = {read=FSplitterWidth, write=FSplitterWidth, nodefault};
	__property TDockClientInfo* DockClientInfo = {read=FDockClientInfo};
	__property Extctrls::TPanel* SplitterPanel = {read=FSplitterPanel};
	
public:
	__fastcall TTabDockPanel(Classes::TComponent* AOwner, TDockClientInfo* DockClientInfo);
	__fastcall virtual ~TTabDockPanel(void);
	void __fastcall UpdateDockCaptionPin(void);
	__property int AnimateSpeed = {read=FAnimateSpeed, write=FAnimateSpeed, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TTabDockPanel(HWND ParentWindow) : Extctrls::TPanel(ParentWindow) { }
	#pragma option pop
	
};


__interface IAlternateDockHost;
typedef System::DelphiInterface<IAlternateDockHost> _di_IAlternateDockHost;
__interface  INTERFACE_UUID("{808A554D-6502-4D77-B6F7-C0749434D9B7}") IAlternateDockHost  : public IInterface 
{
	
public:
	virtual void __fastcall SetAlternateDockHost(const Controls::TWinControl* DockHost) = 0 ;
};

class DELPHICLASS TCaptionedTabDockTree;
class PASCALIMPLEMENTATION TCaptionedTabDockTree : public Captioneddocktree::TCaptionedDockTree 
{
	typedef Captioneddocktree::TCaptionedDockTree inherited;
	
private:
	Controls::TWinControl* FAlternateDockHost;
	Controls::TDockZone* __fastcall PinHitTest(const Types::TPoint &MousePos);
	
protected:
	virtual void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y, bool &Handled);
	
public:
	void __fastcall SetAlternateDockHost(const Controls::TWinControl* DockHost);
public:
	#pragma option push -w-inl
	/* TCaptionedDockTree.Create */ inline __fastcall virtual TCaptionedTabDockTree(Controls::TWinControl* DockSite)/* overload */ : Captioneddocktree::TCaptionedDockTree(DockSite) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCaptionedDockTree.Destroy */ inline __fastcall virtual ~TCaptionedTabDockTree(void) { }
	#pragma option pop
	
private:
	void *__IAlternateDockHost;	/* Docktabset::IAlternateDockHost */
	
public:
	operator IAlternateDockHost*(void) { return (IAlternateDockHost*)&__IAlternateDockHost; }
	
};


class DELPHICLASS ETabDockException;
class PASCALIMPLEMENTATION ETabDockException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ETabDockException(const AnsiString Msg) : Sysutils::Exception(Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ETabDockException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ETabDockException(int Ident)/* overload */ : Sysutils::Exception(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ETabDockException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ETabDockException(const AnsiString Msg, int AHelpContext) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ETabDockException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ETabDockException(int Ident, int AHelpContext)/* overload */ : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ETabDockException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ETabDockException(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Docktabset */
using namespace Docktabset;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Docktabset
